def loadmodule(*modules):
    import sys, os
    originalpath = list(sys.path)
    pythonpath = os.environ['PYTHONPATH']
    sys.path = [p for p in sys.path if pythonpath not in p and p != '']

    for module in modules:
        if module in sys.modules:
            del sys.modules[module]
        __import__(module)

    sys.path = originalpath

def getpatchedsslcontext():
    import ssl, os
    # support was added in python 3.6
    context = ssl.SSLContext(ssl.PROTOCOL_TLS)
    context.load_verify_locations(os.environ['SSL_CERT_FILE'])
    return context
