import fiddlerutils

fiddlerutils.loadmodule('http', 'http.client')

import http.client, os

proxyurl = os.environ['HTTP_PROXY']
[proxyhost, proxyport] = proxyurl.split('://')[1].split(':')
proxyport = int(proxyport)
certpath = os.environ['SSL_CERT_FILE']

originit = http.client.HTTPConnection.__init__

def __patchedHTTPConnectionInit__(self, host, port=None, *args, **kwargs):
    originit(self, proxyhost, proxyport, *args, **kwargs)
    # some libaries like urllib handle proxy on their own, so they pass us the proxy directly
    if proxyhost not in host and str(proxyport) not in host and str(proxyport) not in str(port):
        self.set_tunnel(host, port)

origsinit = http.client.HTTPSConnection.__init__

def __patchedHTTPSConnectionInit__(self, host, port=None, *args, **kwargs):
    kwargs['context'] = fiddlerutils.getpatchedsslcontext()
    origsinit(self, proxyhost, proxyport, *args, **kwargs)
    # some libaries like urllib handle proxy on their own, so they pass us the proxy directly
    if proxyhost not in host and str(proxyport) not in host and str(proxyport) not in str(port):
        self.set_tunnel(host, port)

http.client.HTTPConnection.__init__ = __patchedHTTPConnectionInit__
http.client.HTTPSConnection.__init__ = __patchedHTTPSConnectionInit__
