if ('system.net.webrequest' -as [type]) {
    [System.Net.WebRequest]::DefaultWebProxy = New-Object System.Net.WebProxy($env:HTTPS_PROXY)
}

if ('system.net.http.httpclient' -as [type]) {
    [System.Net.Http.HttpClient]::DefaultProxy = New-Object System.Net.WebProxy($env:HTTPS_PROXY)
}

# Win Powershell
if ($PSVersionTable.PSVersion.Major -lt 7) {
    if (-not ([System.Management.Automation.PSTypeName]'ServerCertificateValidationCallback').Type) {
        add-type @"
    using System;
    using System.Net;
    using System.Net.Security;
    using System.Security.Cryptography.X509Certificates;
    public class ServerCertificateValidationCallback
    {
        public static void Ignore()
        {
            if(ServicePointManager.ServerCertificateValidationCallback == null)
            {
                ServicePointManager.ServerCertificateValidationCallback += 
                    delegate
                    (
                        Object obj, 
                        X509Certificate certificate, 
                        X509Chain chain, 
                        SslPolicyErrors errors
                    )
                    {
                        return true;
                    };
            }
        }
    }
"@
    }
    [ServerCertificateValidationCallback]::Ignore()
}
# PS core
else {
    $PSDefaultParameterValues = @{"Invoke-WebRequest:SkipCertificateCheck" = $true }
}

$Host.UI.RawUI.WindowTitle = 'Fiddler PowerShell'
echo ''
echo 'Fiddler Everywhere has applied the following changes'
echo '  * Powershell is running with "Unrestricted" ExecutionPolicy. For more information,'
echo '    see about_Execution_Policies at https:/go.microsoft.com/fwlink/?LinkID=135170'
echo '  * Updated environment variables'
echo '  * Set the DefaultProxy of the HttpClient/WebRequest class (Invoke-WebRequest will use the proxy)' 


if ((Get-Command curl -errorAction SilentlyContinue).Path) {
    $curlPath = (Get-Command curl).Path
    function Invoke-Curl {
        $args += "-k"	
        &"$curlPath" @args
    }

    Set-Alias -Name curl -Value Invoke-Curl
    echo '  * Curl will be invoked with -k by default'
}

if ((Get-Command node -errorAction SilentlyContinue).Path) {
    $nodePath = (Get-Command node).Path
    function Invoke-Node {
        $preloadArgs = ("-r", "${env:NODE_PRELOAD_SCRIPT}")
        $args = $preloadArgs + $args
        &"$nodePath" @args
    }

    Set-Alias -Name node -Value Invoke-Node
    echo '  * Node will be using global-agent and fetch is patched to use proxy'
}

echo ''
echo 'For more information and current limitations, refer to https://docs.telerik.com/fiddler-everywhere/knowledge-base/capturing-traffic-from-terminal'
echo ''
